% Model of a non-steady state non-isothermal plug flow reactor - Gas phase

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

[s1,s2] = size(T)
s_1 = 7
c(1:101,1) = Y(s_1,1:101);
c(1:101,2) = Y(s_1,102:202);
c(1:101,3) = Y(s_1,203:303);
Tempf(1:101,1) = Y(s_1,304:404);
for j = 1:101
    ctotf(j,1) = c(j,1) + c(j,2) + c(j,3);
    pf(j,1) = ctotf(j,1)*R*Tempf(j,1);
    Vf(j,1) = (j-1)*V/100;
end

figure(1)
plot(Vf,c)
xlabel('Reactor volume (m3)');
ylabel('Concentration (mol/m3)');
figure(2)
plot(Vf,pf)
xlabel('Reactor volume (m3)');
ylabel('Pressure (Pa)');
figure(3)
plot(Vf,Tempf)
xlabel('Reactor volume (m3)');
ylabel('Temperature (K))');figure(1)
figure(4)
plot(Vf,ctotf)
xlabel('Reactor volume (m3)');
ylabel('Total concentration (mol/m3)');
V
Y
dpdVout = (pf(101,1) - pf(100,1))/deltaV;
rhoout = c(101,1)*ME + c(101,2)*MH + c(101,3)*MA;
Gout = (1/3.5)*(-150*(1-phi)*mu/dp + sqrt((150*(1-phi)*mu/dp)^2 - 7*dpdVout*rhoout*OMEGA*dp*phi^3/(1-phi)));
usout = Gout/rhoout;
conversion = (nHin - usout*OMEGA*c(101,2))/nHin
